/*****************************************************************************
*  LPC81x SCT WS2812 demo
*
*  Use L counter part to generate a 50 KHz PWM signal at SCT_OUTP_0
*****************************************************************************/
#include "LPC8xx.h"

#define	TSAMPLE         1                   // input data sampling point; frequency independent

/*** SystemCoreClock = 24 MHz ***/
#define	T0H             8                   //  8/24 MHz = 0.333 us @ 24 MHz (spec: 0.35 us)
#define	T1H             17                  // 17/24 MHz = 0.708 us @ 24 MHz (spec: 0.70 us)
#define	TDONE           (24 * 60)           // 50+10 us @ 24 MHz delay for the done event

/*** SystemCoreClock = 12 MHz ***/
//#define	T0H             5                   //  5/12 MHz = 0.417 us @ 12 MHz (spec: 0.35 us)
//#define	T1H             8                   //  8/12 MHz = 0.667 us @ 12 MHz (spec: 0.70 us)
//#define	TDONE           (12*(50+10))        // 50+10 us @ 12 MHz delay for the done event

void SCT_Init(void)
{
    LPC_SYSCON->SYSAHBCLKCTRL |= (1 << 8);                  // enable the SCT clock

	LPC_SCT->CONFIG            = (1 << 0) |                 // unified 32-bit counter
                                 (1 << 7);                  // do not reload match registers

    LPC_SCT->OUTPUT            = (0 << 0);                  // initial output low

    LPC_SCT->MATCH[0].U        = TSAMPLE - 1;               // sampling point match value
    LPC_SCT->MATCH[1].U        = T0H - 1;                   // out 0 match value
    LPC_SCT->MATCH[2].U        = T1H - 1;                   // out 1 match value
    LPC_SCT->MATCH[3].U        = TDONE - 1;                 // sequence done match value

	// a rising edge on IN0 (SCK) generates this event; this event does not change the state
	// this is a limiting and start event; on this event drive OUT0 (WS2812 data) high
    LPC_SCT->EVENT[0].STATE    = 0x00000003;                // event 0 happens in all states
    LPC_SCT->EVENT[0].CTRL     = (0 << 5)  |                // OUTSEL[5]       = input selected
                                 (0 << 6)  |                // IOSEL[9:6]      = select IO 0
                                 (1 << 10) |                // IOCOND[11:10]   = rising edge
                                 (2 << 12) |                // COMBMODE[13:12] = IO condition only
                                 (0 << 14) |                // STATELD[14]     = STATEV is added to state
                                 (0 << 15);                 // STATEV[15]      = 0 (no change)

	// TSAMPLE match AND low on IN1 (MOSI) generates this event; on this event go to state 0
    LPC_SCT->EVENT[1].STATE    = 0x00000003;                // event 1 happens in all states
    LPC_SCT->EVENT[1].CTRL     = (0 << 0)  |                // MATCHSEL[3:0]   = related to match 0 (TSAMPLE)
                                 (0 << 5)  |                // OUTSEL[5]       = input selected
                                 (1 << 6)  |                // IOSEL[9:6]      = select IO 1
                                 (0 << 10) |                // IOCOND[11:10]   = low
                                 (3 << 12) |                // COMBMODE[13:12] = match AND IO condition
                                 (1 << 14) |                // STATELD[14]     = STATEV is loaded into state
                                 (0 << 15);                 // STATEV[15]      = 0 (goto state 0)

	// TSAMPLE match AND high on IN1 (MOSI) generates this event; on this event go to state 1
    LPC_SCT->EVENT[2].STATE    = 0x00000003;                // event 2 happens in all states
    LPC_SCT->EVENT[2].CTRL     = (0 << 0)  |                // MATCHSEL[3:0]   = related to match 0(TSAMPLE)
                                 (0 << 5)  |                // OUTSEL[5]       = input selected
                                 (1 << 6)  |                // IOSEL[9:6]      = select IO 1
                                 (3 << 10) |                // IOCOND[11:10]   = high
                                 (3 << 12) |                // COMBMODE[13:12] = match AND IO condition
                                 (1 << 14) |                // STATELD[14]     = STATEV is loaded into state
                                 (1 << 15);                 // STATEV[15]      = 1 (goto state 1)

	// T0H match generates this event; on this event do not change state
	// on this event drive OUT0 (WS2812 data) low
    LPC_SCT->EVENT[3].STATE    = 0x00000001;                // event 3 happens in state 0 only
    LPC_SCT->EVENT[3].CTRL     = (1 << 0)  |                // MATCHSEL[3:0]   = related to match 1 (T0H)
                                 (1 << 12) |                // COMBMODE[13:12] = match only condition
                                 (0 << 14) |                // STATELD[14]     = STATEV is added to state
                                 (0 << 15);                 // STATEV[15]      = 0 (no change)

	// T1H match generates this event; on this event do not change state
	// on this event drive OUT0 (WS2812 data) low
    LPC_SCT->EVENT[4].STATE    = 0x00000002;                // event 4 happens in state 1 only
    LPC_SCT->EVENT[4].CTRL     = (2 << 0)  |                // MATCHSEL[3:0]   = related to match 2 (T1H)
                                 (1 << 12) |                // COMBMODE[13:12] = match only condition
                                 (0 << 14) |                // STATELD[14]     = STATEV is added to state
                                 (0 << 15);                 // STATEV[15]      = 0 (no change)

	// TDONE match generates this event; on this event do not change state
	// this event stops the SCT and generates an interrupt;
    LPC_SCT->EVENT[5].STATE    = (3 << 0);                  // event 5 happens in all states
    LPC_SCT->EVENT[5].CTRL     = (3 << 0)  |                // MATCHSEL[3:0]   = related to match 3 (TDONE)
                                 (1 << 12) |                // COMBMODE[13:12] = match only condition
                                 (0 << 14) |                // STATELD[14]     = STATEV is added to state
                                 (0 << 15);                 // STATEV[15]      = 0 (no change)

    LPC_SCT->OUT[0].SET        = (1 << 0);                  // event 0 will set OUT0 (WS2812 data)
    LPC_SCT->OUT[0].CLR        = (1 << 3) | (1 << 4);       // event 3 and 4 will clear OUT0 (WS2812 data)

    LPC_SCT->LIMIT_L          |= (1 << 0);                  // event 0 will limit the counter
    LPC_SCT->START_L          |= (1 << 0);                  // event 0 will start the counter
    LPC_SCT->STOP_L           |= (1 << 5);                  // event 5 will stop the counter
    LPC_SCT->EVEN              = (1 << 5);                  // event 5 generates an interrupt

    NVIC_EnableIRQ(SCT_IRQn);                               // enable SCT interrupt

    LPC_SCT->COUNT_U           = TDONE - 2;                 // prime the counter
    LPC_SCT->CTRL_U           &= ~(1 << 2);                 // unhalt it
}
